package w83b.w83bOperacionesPaso.w83bResultados;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaDelegConvenioExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bDelegConvenio.xls";
		InputStream inputStream = W83bTablaDelegConvenioExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		Comparator comparador=Collections.reverseOrder();
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        Map general = (HashMap)contexto.get("w83bMapResultadosBean");
        Map sectores=(HashMap)general.get("sectores");
        W83bResultadosBean resultadoBean = (W83bResultadosBean)contexto.get("w83bResultadosBean");
        Double porcentajeFiltro=new Double(0.0);
        if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())){
        	String porc=resultadoBean.getPorcentaje().replace(',','.');
    		porcentajeFiltro = new Double(porc);
        }
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
        
        HSSFRow row;
        HSSFCell cell;
        HSSFCell cell3;
        HSSFCell cell2;
        HSSFCell cell4;
       
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)5);
        
        StringBuffer tituloImagenEs = new StringBuffer();
        StringBuffer tituloImagenEu = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEs = new StringBuffer();
        tituloImagenEu = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
        	        
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)5);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)10); 
        cell = row.createCell((short)6); 
        
    	if(StringUtils.isNotEmpty(resultadoBean.getFechaHistorico())){
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.historicos.afecha",idioma,new String[]{resultadoBean.getFechaHistorico(), resultadoBean.getFeHist()}));
    	}
        
        row = sheet.getRow((short)11); 
         
        HSSFCell cell5;  
        HSSFCell cell6;
             

        cell = row.getCell((short)2); 
        if(StringUtils.isNotEmpty(resultadoBean.getDescTerritorio())){
        	cell.setCellValue(resultadoBean.getDescTerritorio().toUpperCase());
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("2"),11,Short.parseShort("3")));//NOPMD
		}
        cell = row.getCell((short)3); 
        
        cell = row.getCell((short)5); 
        if(StringUtils.isNotEmpty(resultadoBean.getSectorTxt())){
        	cell.setCellValue(resultadoBean.getSectorTxt());
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("5"),11,Short.parseShort("10")));//NOPMD
		}
        cell = row.getCell((short)6); 
        cell = row.getCell((short)7); 
        cell = row.getCell((short)8); 
        cell = row.getCell((short)9); 
        cell = row.getCell((short)10); 
        
        cell = row.getCell((short)13); 
        if(StringUtils.isNotEmpty(resultadoBean.getConvenioTxt())){
        	cell.setCellValue(resultadoBean.getConvenioTxt());
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(11,Short.parseShort("13"),11,Short.parseShort("17")));//NOPMD
		}
        cell = row.getCell((short)14); 
        
        row = sheet.getRow((short)12); 
        
        cell = row.getCell((short)3); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionDesde())){
        	cell.setCellValue(resultadoBean.getFechaEleccionDesde());
        }
       
        cell = row.getCell((short)6); 
        
        if(StringUtils.isNotEmpty(resultadoBean.getFechaEleccionHasta())){
        	cell.setCellValue(resultadoBean.getFechaEleccionHasta());
        }
        if(!W83bClsConstantes.VACIO.equals(cell.getStringCellValue()))
		{
	 		sheet.addMergedRegion(new Region(12,Short.parseShort("6"),12,Short.parseShort("7")));//NOPMD
	 		cell = row.createCell((short)7); 
	       
		}
        
        
        cell = row.getCell((short)14); 
        if(StringUtils.isNotEmpty(resultadoBean.getFechaRegistroDefinitivo())){
        	cell.setCellValue(resultadoBean.getFechaRegistroDefinitivo());
        }
        
        cell = row.getCell((short)16); 
        cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma));
       
        
        if(resultadoBean.getPorcentaje()!=null && !"".equals(resultadoBean.getPorcentaje())){
	        cell = row.createCell((short)17); 
	        cell.setCellValue(porcentajeFiltro+"%");
	       
        }
        
        int contador=14;
        
        Map mapSectoresOrdenado = new TreeMap(sectores);
        Set ref = mapSectoresOrdenado.keySet();
        
        String[]valores;
        String sector;
        String convenio;
        
        //Totales sector
        int numempresas;
        int numcentros;
        int totalelectores;
        int numvotos;
        int totaldelegados;
        List sindicatossector=new ArrayList();
        
        //Totales territorio
        //int numempresasterrit=0;
        //int numcentrosterrit=0;
        int totalelectoresterrit=0;
        int numvotosterrit=0;
        int totaldelegadosterrit=0;
        List sindicatossectorterrit=new ArrayList();
       int lineascuerpo=0;
       int pag=0;
	   for( Iterator it = ref.iterator(); it.hasNext();) {
		    pag=pag+1;
		    lineascuerpo=0;
		    numempresas=0;
	        numcentros=0;
	        totalelectores=0;
	        numvotos=0;
	        totaldelegados=0;
	        sindicatossector=new ArrayList();//NOPMD
		    sector=(String)it.next();
        	contador=contador+2;
        	lineascuerpo=lineascuerpo+2;
        	row = sheet.createRow((short)contador); 
        	cell = row.createCell((short)1);
            cell2 = row.createCell((short)2);
            cell3 = row.createCell((short)3);
            cell4 = row.createCell((short)4);
            cell5 = row.createCell((short)5);
            sheet.addMergedRegion(new Region((short)contador,(short)1,(short)contador,(short)5));//NOPMD
        	valores=sector.split("\\|");
        	//Descripcin sector
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.centroTrabajo.sector",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase()+": "+valores[1]);
        	//Cabecera
        	contador=contador+1;
        	row = sheet.createRow((short)contador); 
        	cell = row.createCell((short)13);
        	cell.setCellStyle(styleTextoImparCentrado(excel));
        	cell2 = row.createCell((short)14);
        	cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell3 = row.createCell((short)15);
            cell3.setCellStyle(styleTextoImparCentrado(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralsindical",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralsindical",W83bClsConstantes.CONSTANTE_CASTELLANO));
            row = sheet.createRow((short)contador+1); 
            cell = row.createCell((short)13);
            cell.setCellStyle(styleTextoImparCentrado(excel));
            sheet.addMergedRegion(new Region((short)contador,(short)13,(short)contador+1,(short)15));//NOPMD
            row = sheet.createRow((short)contador); 
            cell = row.createCell((short)16);
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell2 = row.createCell((short)17);
            cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.menu.Delegados",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.menu.Delegados",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            sheet.addMergedRegion(new Region((short)contador,(short)16,(short)contador+1,(short)17));//NOPMD
            contador=contador+1;
            row = sheet.createRow((short)contador); 
            cell = row.createCell((short)14);
            cell.setCellStyle(excel.styleBordeIzda);
            cell2 = row.createCell((short)15);
            cell2.setCellStyle(excel.styleBordeDcha);
            cell3 = row.createCell((short)16);
            cell3.setCellStyle(excel.styleBordeIzda);
            cell4 = row.createCell((short)17);
            cell4.setCellStyle(excel.styleBordeDcha);	 
        	
        	contador=contador+1;
        	lineascuerpo=lineascuerpo+3;
        	row = sheet.createRow((short)contador); 
        	cell = row.createCell((short)0);
        	cell2 = row.createCell((short)1);
        	cell3 = row.createCell((short)2);
        	cell4 = row.createCell((short)3);
        	cell5 = row.createCell((short)4);
        	cell6 = row.createCell((short)5);
        	sheet.addMergedRegion(new Region((short)contador,(short)0,(short)contador,(short)5));//NOPMD
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.denominacionconvenio",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.denominacionconvenio",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell3.setCellStyle(styleTextoImparCentrado(excel));
            cell4.setCellStyle(styleTextoImparCentrado(excel));
            cell5.setCellStyle(styleTextoImparCentrado(excel));
            cell6.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)6);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.empr",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.empr",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)7);
            cell2 = row.createCell((short)8);
            sheet.addMergedRegion(new Region((short)contador,(short)7,(short)contador,(short)8)); //NOPMD
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centros",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centros",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)9);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.elect",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.elect",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)10);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.votant",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.votant",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)11);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.deleg",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.deleg",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)12);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.partic",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.partic",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)13);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cod",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.cod",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)14);
            cell2 = row.createCell((short)15);
            sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.sindicatos.siglas",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.sindicatos.siglas",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell2.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)16);
            cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.num",W83bClsConstantes.CONSTANTE_EUSKARA).toUpperCase()+"/"+"\n"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.num",W83bClsConstantes.CONSTANTE_CASTELLANO).toUpperCase());
            cell.setCellStyle(styleTextoImparCentrado(excel));
            cell = row.createCell((short)17);
            cell.setCellValue("%");
            cell.setCellStyle(styleTextoImparCentrado(excel));
            int numdelegados;
            int filadeleg;
            int e=0;
            int v=0;
            //Descripcin convenio
            Map mapConveniosOrdenado = new TreeMap((Map)mapSectoresOrdenado.get(sector));//NOPMD
            Set refc = mapConveniosOrdenado.keySet();
        	for(Iterator itconv = refc.iterator(); itconv.hasNext();) { 
        		convenio=(String)itconv.next();
        		numdelegados=0;
                filadeleg=0;
                contador=contador+1;
                lineascuerpo=lineascuerpo+1;
                row = sheet.createRow((short)contador); 
                cell = row.createCell((short)0);
            	valores=convenio.split("\\|");
            	if(StringUtils.isNotEmpty(valores[1])){
            		cell.setCellValue(Integer.parseInt(valores[0])+"-"+valores[1]);
            	}
            	String datos=(String)((List)mapConveniosOrdenado.get(convenio)).get(((List)mapConveniosOrdenado.get(convenio)).size()-1);
            	valores=datos.split("\\|");
            	cell = row.createCell((short)6);
            	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
            	if(StringUtils.isNotEmpty(valores[0])){
            		cell.setCellValue(W83bUtilidades.numero(valores[0]));
            	}
            	numempresas=numempresas+Integer.parseInt(valores[0]);
            	//numempresasterrit=numempresasterrit+Integer.parseInt(valores[0]);
            	cell = row.createCell((short)7);
            	cell2 = row.createCell((short)8);
            	sheet.addMergedRegion(new Region((short)contador,(short)7,(short)contador,(short)8));//NOPMD
            	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
            	if(StringUtils.isNotEmpty(valores[1])){
            		cell.setCellValue(W83bUtilidades.numero(valores[1]));
            	}
            	numcentros=numcentros+Integer.parseInt(valores[1]);
            	//numcentrosterrit=numcentrosterrit+Integer.parseInt(valores[1]);
            	cell = row.createCell((short)9);
            	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
            	if(StringUtils.isNotEmpty(valores[2])){
            		cell.setCellValue(W83bUtilidades.numero(valores[2]));
            	}
            	totalelectores=totalelectores+Integer.parseInt(valores[2]);
            	e=Integer.parseInt(valores[2]);
            	totalelectoresterrit=totalelectoresterrit+Integer.parseInt(valores[2]);
            	cell = row.createCell((short)10);
            	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
            	if(StringUtils.isNotEmpty(valores[3])){
            		cell.setCellValue(W83bUtilidades.numero(valores[3]));
            	}
            	numvotos=numvotos+Integer.parseInt(valores[3]);
            	numvotosterrit=numvotosterrit+Integer.parseInt(valores[3]);
            	v=Integer.parseInt(valores[3]);
            	filadeleg=contador;
            	for (int i=0;i<((List)mapConveniosOrdenado.get(convenio)).size()-1;i++){
            		valores=((String)((List)mapConveniosOrdenado.get(convenio)).get(i)).split("\\|");
            		numdelegados=numdelegados+Integer.parseInt(valores[0]);
            	}
            	//entra aki por cada convenio
            	boolean otros=false;
            	int delegados=0;
            	//recogemos el ultimo
            	List listanueva=((List)mapConveniosOrdenado.get(convenio));
            	String ultimo=(String)((List)mapConveniosOrdenado.get(convenio)).get(((List)mapConveniosOrdenado.get(convenio)).size()-1);
            	listanueva.remove(((List)mapConveniosOrdenado.get(convenio)).size()-1);
            	//borramos el ultimo para ordenar la lista
            	Collections.sort(listanueva,comparador);//la ordenamos de mayor a menor
            	listanueva.add(ultimo);//metemos de nuevo el ultimo
            	for (int i=0;i<listanueva.size()-1;i++){//(List)mapConveniosOrdenado.get(convenio)
            		sindicatossector=W83bUtilidadesComunes.listaSindicatos(sindicatossector, (String)(listanueva).get(i));
            		sindicatossectorterrit=W83bUtilidadesComunes.listaSindicatos(sindicatossectorterrit, (String)(listanueva).get(i));
            		valores=((String)(listanueva).get(i)).split("\\|");
            		//debemos mirar  si el % supera el que hemos puesto, para ponerlo en otros
            		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),numdelegados)*100<porcentajeFiltro.floatValue()){//
            			delegados=delegados+Integer.parseInt(valores[0]);//
            			otros=true;
            		}
            		else{
	            		cell = row.createCell((short)13);
	            		cell.setCellStyle(styleCentrado(excel));
	            		if ("-1".equals(valores[2])){//
	            			cell.setCellValue("");
	            		}
	            		else{
	            			if(StringUtils.isNotEmpty(valores[2])){
	            				cell.setCellValue(W83bUtilidades.numero(valores[2]));//
	            			}
	            		}
	                	
	                	cell = row.createCell((short)14);
	                	
	                	cell2 = row.createCell((short)15);
	                	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
	                	if ("-1".equals(valores[2])){//
	                		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralnoespecificada",idioma).toUpperCase());
	            		}else if ("null".equals(valores[1])){
	            			cell.setCellValue("");
	            		}
	            		else{
	            			if(StringUtils.isNotEmpty(valores[1])){
	            				cell.setCellValue(valores[1]);
	            			}
	            		}
	                	cell = row.createCell((short)16);
	                	
	                	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	                	if(StringUtils.isNotEmpty(valores[0])){
	                		cell.setCellValue(W83bUtilidades.numero(valores[0]));//
	                	}
	                	totaldelegados=totaldelegados+Integer.parseInt(valores[0]);//
	                	
	                	totaldelegadosterrit=totaldelegadosterrit+Integer.parseInt(valores[0]);//
	                	cell = row.createCell((short)17);
	                	cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),numdelegados));//
	                	cell.setCellStyle(stylePorcentajesDcha(excel));
	                	contador=contador+1;
	                	lineascuerpo=lineascuerpo+1;
	                	row = sheet.createRow((short)contador);   
            		}
            	}
            	if(otros){
            		totaldelegados=totaldelegados+delegados;
            		totaldelegadosterrit=totaldelegadosterrit+delegados;
            		//metemos la linea de otros
            		cell = row.createCell((short)14);
                	cell2 = row.createCell((short)15);
                	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
            		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",idioma).toUpperCase());
            		
            		cell = row.createCell((short)16);
            		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
            		cell.setCellValue(delegados);
            		
            		cell = row.createCell((short)17);
                	cell.setCellValue(W83bUtilidades.porcentaje(delegados,numdelegados));
                	cell.setCellStyle(stylePorcentajesDcha(excel));
            		
            		
            		contador=contador+1;
            		lineascuerpo=lineascuerpo+1;
                	row = sheet.createRow((short)contador);
            		
            	}
            	row = sheet.createRow((short)filadeleg);
            	cell = row.createCell((short)11);
            	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
            	cell.setCellValue(numdelegados);
            	cell = row.createCell((short)12);            	
            	cell.setCellValue(W83bUtilidades.porcentaje(v,e));
            	cell.setCellStyle(excel.stylePorcentajesDcha);
        	}
        	contador=contador+1;
        	lineascuerpo=lineascuerpo+1;
        	row = sheet.createRow((short)contador);
        	cell = row.createCell((short)0);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)1);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)2);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)3);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)4);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)5);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)6);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)7);
        	cell2 = row.createCell((short)8);
        	sheet.addMergedRegion(new Region((short)contador,(short)7,(short)contador,(short)8));//NOPMD
        	cell.setCellStyle(bordeArriba(excel));
        	cell2.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)9);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)10);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)11);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)12);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)13);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)14);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)15);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)16);
        	cell.setCellStyle(bordeArriba(excel));
        	cell = row.createCell((short)17);
        	cell.setCellStyle(bordeArriba(excel));
        	
        	contador=contador+1;
        	lineascuerpo=lineascuerpo+1;
        	row = sheet.createRow((short)contador);
        	cell = row.createCell((short)0);
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalsector",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalsector",W83bClsConstantes.CONSTANTE_CASTELLANO));
        	cell = row.createCell((short)6);
        	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
        	cell.setCellValue(numempresas);
        	cell = row.createCell((short)7);
        	cell2 = row.createCell((short)8);
        	sheet.addMergedRegion(new Region((short)contador,(short)7,(short)contador,(short)8));//NOPMD
        	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
        	cell.setCellValue(numcentros);
        	cell = row.createCell((short)9);
        	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
        	cell.setCellValue(totalelectores);
        	cell = row.createCell((short)10);
        	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
        	cell.setCellValue(numvotos);
        	cell = row.createCell((short)11);
        	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
        	cell.setCellValue(totaldelegados);
        	cell = row.createCell((short)12);
        	cell.setCellValue(W83bUtilidades.porcentaje(numvotos,totalelectores));
        	cell.setCellStyle(excel.stylePorcentajesDcha);
        	boolean otros=false;
        	int delegados=0;
        	//ordenarlo
        	Collections.sort(sindicatossector,comparador);//la ordenamos de mayor a menor
        	for (int i=0;i<sindicatossector.size();i++){
        		
        		valores=((String)sindicatossector.get(i)).split("\\|");
        		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegados)*100<porcentajeFiltro.floatValue()){//
        			delegados=delegados+Integer.parseInt(valores[0]);//
        			otros=true;
        		}
        		else{
	        		cell = row.createCell((short)13);
	        		cell.setCellStyle(styleCentrado(excel));
	        		if ("-1".equals(valores[2])){//
	        			cell.setCellValue("");
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[2])){
	        				cell.setCellValue(W83bUtilidades.numero	(valores[2]));//
	        			}
	        		}
	            	cell = row.createCell((short)14);
	            	cell2 = row.createCell((short)15);
	            	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
	            	if ("-1".equals(valores[2])){//
	            		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralnoespecificada",idioma).toUpperCase());
	        		}else if ("null".equals(valores[1])){
	        			cell.setCellValue("");
	        		}
	        		else{
	        			if(StringUtils.isNotEmpty(valores[1])){
	        				cell.setCellValue(valores[1]);
	        			}
	        		}
	            	cell = row.createCell((short)16);
	            	cell.setCellStyle(stylePorcentajesDcha(excel));
	            	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	            	if(StringUtils.isNotEmpty(valores[0])){
	            		cell.setCellValue(W83bUtilidades.numero(valores[0]));//
	            	}
	            	cell = row.createCell((short)17);
	            	cell.setCellStyle(stylePorcentajesDcha(excel));
	            	cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegados));//
	            	contador=contador+1;
	            	lineascuerpo=lineascuerpo+1;
	            	row = sheet.createRow((short)contador); 
        		}
        	}
        	if(otros){
        		//metemos la linea de otros
        		cell = row.createCell((short)14);
            	cell2 = row.createCell((short)15);
            	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",idioma).toUpperCase());
        		
        		cell = row.createCell((short)16);
        		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
        		cell.setCellValue(delegados);
        		
        		cell = row.createCell((short)17);
            	cell.setCellValue(W83bUtilidades.porcentaje(delegados,totaldelegados));
            	cell.setCellStyle(stylePorcentajesDcha(excel));
        		
        		contador=contador+1;
        		lineascuerpo=lineascuerpo+1;
            	
            	row = sheet.createRow((short)contador);
        	}
    		if (it.hasNext()){
    	   		int paginas=0;
        		int lineasrestantes=0;
        		int lineasultimapagina=0;
        		 //Paginacin
        		//La primera pgina tiene 40 y el resto 53
        		if (pag==1){
        			if (lineascuerpo<=40){
        				lineasrestantes=40-lineascuerpo;
        			}
        			else{
        				lineascuerpo=lineascuerpo-40;
        				if ((lineascuerpo-1)%53==0){
        					paginas=lineascuerpo/53;
        				}
        				else{
        					paginas=1+(lineascuerpo/53);
        				}
            		    lineasultimapagina=40+(paginas*53);
            		    lineasrestantes=lineasultimapagina-lineascuerpo-40;
        			}
        		}
        		else{
        			if (lineascuerpo<=53){
        				lineasrestantes=53-lineascuerpo;
        			}
        			else{
        				if ((lineascuerpo-1)%53==0){
        					paginas=lineascuerpo/53;
        				}
        				else{
        					paginas=1+(lineascuerpo/53);
        				}
        				lineasultimapagina=paginas*53;
        				lineasrestantes=lineasultimapagina-lineascuerpo;
        			}
        		}
        	   contador=contador+lineasrestantes;
    		}

        }
	   
		contador=contador+1;
	   	row = sheet.createRow((short)contador);
	   	cell = row.createCell((short)0);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)1);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)2);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)3);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)4);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)5);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)6);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)7);
	   	cell2 = row.createCell((short)8);
	   	sheet.addMergedRegion(new Region((short)contador,(short)7,(short)contador,(short)8));
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell2.setCellStyle(bordeArriba(excel));
	   	
	   	cell = row.createCell((short)9);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)10);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)11);
	   	cell.setCellStyle(bordeArriba(excel));
	   	
	   	cell = row.createCell((short)12);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)13);
	   	cell.setCellStyle(bordeArriba(excel));
	   	
	   	cell = row.createCell((short)14);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)15);
	   	cell.setCellStyle(bordeArriba(excel));
	   	
	   	cell = row.createCell((short)16);
	   	cell.setCellStyle(bordeArriba(excel));
	   	cell = row.createCell((short)17);
	   	cell.setCellStyle(bordeArriba(excel));
	   	contador=contador+1;
   		row = sheet.createRow((short)contador);
   		cell = row.createCell((short)0);
   		if (!"".equals(resultadoBean.getDescTerritorio())){
   			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalterritorio",W83bClsConstantes.CONSTANTE_CASTELLANO));
   		}
   		else{
   			cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_EUSKARA)+"/"+Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.totalcomunidad",W83bClsConstantes.CONSTANTE_CASTELLANO));
   		}
   		List numempresasycentros = (ArrayList)general.get("numempresasycentros");
        int numempresascomunidad=numempresasycentros.size();
        int numcentroscomunidad=0;
        for (int i=0;i<numempresasycentros.size();i++){
        	numcentroscomunidad=numcentroscomunidad+Integer.parseInt(((W83bResultadosBean)numempresasycentros.get(i)).getNumcentros());
        }
   		cell = row.createCell((short)6);
   		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
//   		cell.setCellStyle(styleCentrado(excel));
   		//cell.setCellValue(numempresasterrit);
   		cell.setCellValue(numempresascomunidad);
   		cell = row.createCell((short)7);
   		cell2 = row.createCell((short)8);
   		sheet.addMergedRegion(new Region((short)contador,(short)7,(short)contador,(short)8));
   		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
   		//cell.setCellValue(numcentrosterrit);
   		cell.setCellValue(numcentroscomunidad);
   		cell = row.createCell((short)9);
   		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	   	cell.setCellValue(totalelectoresterrit);
	   	cell = row.createCell((short)10);
	   	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	   	cell.setCellValue(numvotosterrit);
	   	cell = row.createCell((short)11);
	   	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	   	cell.setCellValue(totaldelegadosterrit);
	   	cell = row.createCell((short)12);
	   	cell.setCellValue(W83bUtilidades.porcentaje(numvotosterrit,totalelectoresterrit));
	   	cell.setCellStyle(excel.stylePorcentajesDcha);
	 	boolean otros=false;
	 	int delegados=0;
	 	//ordenarlo
	 	Collections.sort(sindicatossectorterrit,comparador);//la ordenamos de mayor a menor
	   	for (int i=0;i<sindicatossectorterrit.size();i++){
    		valores=((String)sindicatossectorterrit.get(i)).split("\\|");  
    		if(StringUtils.isNotEmpty(resultadoBean.getPorcentaje())&&W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegadosterrit)*100<porcentajeFiltro.floatValue()){//
    			delegados=delegados+Integer.parseInt(valores[0]);//
    			otros=true;
    		}
    		else{
	    		cell = row.createCell((short)13);
	    		cell.setCellStyle(styleCentrado(excel));
	    		if ("-1".equals(valores[2])){//
	    			cell.setCellValue("");
	    		}
	    		else{
	    			if(StringUtils.isNotEmpty(valores[2])){
	    				cell.setCellValue(W83bUtilidades.numero(valores[2]));//
	    			}
	    		}
	        	cell = row.createCell((short)14);
	        	
	        	cell2 = row.createCell((short)15);
	        	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
	        	
	        	if ("-1".equals(valores[2])){//
	        		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.centralnoespecificada",idioma).toUpperCase());
	    		}else if ("null".equals(valores[1])){
	    			cell.setCellValue("");
	    		}
	    		else{
	    			if(StringUtils.isNotEmpty(valores[1])){
	    				cell.setCellValue(valores[1]);
	    			}
	    		}
	        	
	        	cell = row.createCell((short)16);
	        	cell.setCellStyle(styleCentradoNumeroFormateado(excel));
	        	if(StringUtils.isNotEmpty(valores[0])){
	        		cell.setCellValue(W83bUtilidades.numero(valores[0]));//
	        	}
	        	
	        	cell = row.createCell((short)17);
	        	cell.setCellStyle(stylePorcentajesDcha(excel));
	        	
	        	cell.setCellValue(W83bUtilidades.porcentaje(Integer.parseInt(valores[0]),totaldelegadosterrit));//
	        	
	        	contador=contador+1;
	        	row = sheet.createRow((short)contador);   
    		}
    	}
	   	if(otros){
    		//metemos la linea de otros
    		cell = row.createCell((short)14);
        	cell2 = row.createCell((short)15);
        	sheet.addMergedRegion(new Region((short)contador,(short)14,(short)contador,(short)15)); //NOPMD
    		cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.otrosInf",idioma).toUpperCase());
    		
    		cell = row.createCell((short)16);
    		cell.setCellStyle(styleCentradoNumeroFormateado(excel));
    		cell.setCellValue(delegados);
    		
    		cell = row.createCell((short)17);
        	cell.setCellValue(W83bUtilidades.porcentaje(delegados,totaldelegadosterrit));
        	cell.setCellStyle(stylePorcentajesDcha(excel));
    		
    		contador=contador+1;
        	
        	row = sheet.createRow((short)contador);
    	}
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoDelegadosPorConvenio.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle stylePorcentajesDcha(W83bUtilidadesExcel excel){
		return excel.stylePorcentajesDcha;			
		
	}
	
	
	private HSSFCellStyle bordeArriba(W83bUtilidadesExcel excel){
		return excel.styleBordeArriba;			
		
	}
	
	private HSSFCellStyle styleCentrado(W83bUtilidadesExcel excel){
		return excel.styleCentrado;			
		
	}
	
	private HSSFCellStyle styleTextoImparCentrado(W83bUtilidadesExcel excel){
		return excel.styleTextoImparCentrado;			
		
	}

	private HSSFCellStyle styleCentradoNumeroFormateado(W83bUtilidadesExcel excel){
		return excel.styleCentradoNumeroFormateado;			
		
	}
}
